// External variables:

// skinPath		- String, relative path of this theme, from System.Gadget.path ie "themes\default"
//				  use this when pulling in graphics.  ie src='" + skinPath + "/graphics.png'"
// EQbands		- Integer, the number of EQ bands the Gadget is configured for
// decayRate	- Integer, the current decayRate setting (0 to 20)
// divGraph		- the DIV to create the display elements in
// bDebug		- Boolean, is the Gadget in debug mode


// External methods:
// debugLog(<text>)	- write a debug log entry
// EQGadget.EQBand([0...<EQbands>]) - Integer, the power spectrum results



// Methods to be included in this code:

// initialize()	- initialize the graphics, setup variables etc
//                you must set the document.body.style.width/height in here
// display()	- display the EQ.  A call should be made to "EQGadget.FFT(EQbands);"
//				  to run an FFT on the current sound output.



var gWidth = 130;			// gadget width
var gHeight = 60;			// gadget height

if (System.Gadget.Settings.readString("orbmu2k_backgroundStyle") != "")
	var backgroundStyle = System.Gadget.Settings.read("orbmu2k_backgroundStyle");
else
	var backgroundStyle = 1;	// the filename of the background style


var barWidth = 4;			// width of the bar
var barHeight = 42;		// the max height of the bars
var eqBars = new Array(EQbands);

var updating = false;

function initialize() {
	var xPos, yPos;

	document.body.style.width = gWidth;
	document.body.style.height = gHeight;

	//set the background
	divGraph.innerHTML += "<g:background id='gbackground' src='" + skinPath + "/backgrounds/background" + backgroundStyle + ".png' style='top:0px; left:0px; width:" + gWidth + "px; height:" + gHeight + "px;' />";
	
	//set bar background
	divGraph.innerHTML += "<img alt='Doubleclick to change background color' id='barback' src='" + skinPath + "/barback.png' style='top:0px; left:0px; width:" + gWidth + "px; height:" + gHeight + "px;' ondblclick='changeBackground();' />";

	//create the EQ bar elements
	for (var j = 0; j < EQbands; j++) {
		xPos = 10 + j * (barWidth + 3);
		yPos = 9;

		// EQ band itself
		divGraph.innerHTML += "<div id='divEQband" + j + "' style='position:absolute;" +
			"overflow:hidden; width:" + barWidth + "px;" +
			"top:" + yPos + "px; " + "left:" + xPos + "px;'><img id='imgEQband" + j + "' " +
			"src='" + skinPath + "/bar.png' style='position:absolute' /></div>";
	}
}

function display() {
	if (updating) return;
	updating = true;

	var eqScale, obj;

	// update the EQ
	for (var j = 0; j < EQbands; j++) {
		try{
			eqScale = parseInt(EQGadget.EQBand(j) * (barHeight/100));
			if (eqScale > barHeight) eqScale = barHeight;
		} catch(err) {
			if (bDebug) debugLog("display1: "+err.name+" - "+err.message);
			eqScale = 0;
		}
		try{
			//decay the bars
			if (decayRate > 0) {
				if (eqScale < eqBars[j]) 
					if (eqBars[j] - decayRate > eqScale)
						eqScale = eqBars[j] - decayRate;
			}

			obj = document.getElementById("divEQband" + j);
			if (eqScale < 1) {
				// hide the bar if it's zero
				if (eqBars[j] > 0) obj.style.display = "none";
			} else {
				// display the bar if it's hidden
				if (eqBars[j] < 1) obj.style.display = "inline";
	
                // only show full LED
                eqScale = (Math.round((eqScale / 4)) * 4);  	
				
				// update the bar height
				var tHeight = barHeight - eqScale;
				obj.style.height = eqScale;
				obj.style.top = 9 + tHeight;
				obj = document.getElementById("imgEQband" + j);
				
				// convert to a string to get around a bug on 64bit IE7
				obj.style.top = String(-tHeight) + "px";
			}
		} catch(err) {debugLog("display2: "+err.name+" - "+err.message)}

		eqBars[j] = eqScale;
	}

	updating = false;
}

function changeBackground()
{
    if (backgroundStyle >= 5)
        backgroundStyle = 1;
    else
        backgroundStyle++;
    
    gbackground.src = skinPath + "/backgrounds/background" + backgroundStyle + ".png";
    System.Gadget.Settings.write("orbmu2k_backgroundStyle", backgroundStyle);
}